#include <windows.h>
#include <commctrl.h>

#include "mylistvw.h"
#include "resource.h"

#include "cpcemu.h"
#include "chtdb.h"

#include "../../cpc_modified/cheatdb.h"
#include "../../special/win/messages.h"
#include "../win/ifacegen.h"

//extern CHEAT_DATABASE *pCheatDatabase;
extern POKEGAMEINFO pgi;

BOOL CALLBACK PokeMemory_DialogProcValue(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);


void InitialiseListViewPGame(HWND hListView)
{
	int i;

	if (hListView!=NULL)
	{
		// ensure list-view is empty
		ListView_DeleteAllItems(hListView);

		for (i = 0; i <GetNumberGame(); i++)
		{

			char Name[255];
			GetNameofGame( i, Name);

			MyListView_AddItem(hListView, Name, 0, i, NULL);

		}
	}
}

//name / description / type
void	InitialiseListViewPOK(HWND hListView)
{
	int nbrePok = pgi.NbrePoke;

	// ensure list-view is empty
	ListView_DeleteAllItems(hListView);

	if ((hListView!=NULL) && (nbrePok>0))
	{
		int i;

		for (i = 0; i < nbrePok; i++)
		{
			MyListView_AddItem(hListView, pgi.PokeInfoByGame[i].Desc, 0, i,(void *)0);
			MyListView_AddItem(hListView, pgi.PokeInfoByGame[i].Commment, 1, i,NULL);
			MyListView_AddItem(hListView, PokType[pgi.PokeInfoByGame[i].type] , 2, i,NULL);

		}
	}
	
}

void ReverseByte(char *str)
{
	if( (strlen(str) > 0) && (strlen(str) < 255) )
	{
		char* first = &str[ 0 ];
		char* last = &str[ strlen( str ) - 1 ];
		while( first < last ) {
			char tmp = *first;
			*first = *last;
			*last = tmp;
			++first;
			--last;
		}
	}
}

void CheckNumByte(char *str, signed int n)
{
	if (strlen(str) == n) return;
	if ((signed int)strlen(str) > n)
	{
		str[n]= '\0';
		return;
	}
	//Warning at memory overflow
	if (strlen(str) < n)
	{
		int i;
		int len = n-strlen(str);
		memmove(str+len,str,strlen(str));
		for (i = 0; i < len; i++ )
		{
			str[i] = '0';
		}
		str[n]= '\0';
		return;
	}
	return;
}

BOOL	CALLBACK CheatDatabase_Dialog_Proc(HWND hDialog, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch (iMsg)
	{
		case WM_INITDIALOG:
		{

			HWND hListView;
			hListView = GetDlgItem(hDialog,IDC_LIST_CHEATS);

			//Load Cheat database
			LoadDatabase(CheatFilename);
	
			ListView_SetExtendedListViewStyleEx(hListView, LVS_EX_FULLROWSELECT, LVS_EX_FULLROWSELECT);
		
			if (hListView!=0)
			{
				MyListView_AddColumn(hListView, Messages[25],0);
				MyListView_AddColumn(hListView, Messages[26],1);
				MyListView_AddColumn(hListView, Messages[27],2);
			}

			InitialiseListViewPOK(hListView);

			hListView = GetDlgItem(hDialog,IDC_LIST_CHEATS_GAME);
			MyListView_AddColumn(hListView, "Games list",0);

			InitialiseListViewPGame(hListView);

		}
		break;

		case WM_NOTIFY:
		{
			//NMHDR FAR *pnmh = (NMHDR FAR *)lParam;
			int idCtrl = (int) wParam;
			LPNMHDR pnmh = (LPNMHDR) lParam;

			switch (pnmh->code)
			{
				case NM_DBLCLK:
                {
					if (idCtrl == IDC_LIST_CHEATS_GAME)
					{
						LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) lParam;
						int s = lpnmitem->iItem;

						CheatSetGame(s);

						InitialiseListViewPOK(GetDlgItem(hDialog,IDC_LIST_CHEATS));
					}
                }
                break;
			}

		}
		break;


		case WM_COMMAND:
		{
			// depending on ID selected
			switch (LOWORD(wParam))
			{
				case ID_OPEN_DATABASE:
				{
					if (Interface_OpenCheatDatabase())
					{
						HWND hListView;
						hListView = GetDlgItem(hDialog,IDC_LIST_CHEATS);

						InitialiseListViewPOK(hListView);

						hListView = GetDlgItem(hDialog,IDC_LIST_CHEATS_GAME);
						InitialiseListViewPGame(hListView);
					}
				}
				break;

				case ID_SEARCH_IN_MEMORY:
				{
					int IdGame = SearchGameinMemory();
					if (IdGame != -1)
					{
						HWND hListView = GetDlgItem(hDialog,IDC_LIST_CHEATS_GAME);
						ListView_SetItemState(hListView,IdGame,LVIS_FOCUSED | LVIS_SELECTED,0x000F);
						CheatSetGame(IdGame);
						InitialiseListViewPOK(GetDlgItem(hDialog,IDC_LIST_CHEATS));
					}
					else
					{
						MessageBox(hDialog, "Sorry, No game found/recognized in memory","Error", MB_OK);
					}
				}
				break;

				case ID_POKE:
				{
					int i;
					int iPos;

					HWND hListView;

					hListView = GetDlgItem(hDialog,IDC_LIST_CHEATS);

					iPos = ListView_GetNextItem(hListView, -1, LVNI_SELECTED);

					if (iPos == -1) return FALSE;

					{
						char Val[255];
						int NbrePoke = pgi.PokeInfoByGame[iPos].npokes;

						for (i = 0; i < NbrePoke; i++)
						{	
							long add = pgi.PokeInfoByGame[iPos].PokeInfo[i].address;
							//unsigned short *byt = pgi.PokeInfoByGame[iPos].PokeInfo[i].byte;
							short n = pgi.PokeInfoByGame[iPos].PokeInfo[i].NbrBytes;
							GetDlgItemText(hDialog, IDC_EDIT_VALUE, (LPSTR)Val,255);
							//GetWindowTextLength(hDialog);

							switch (pgi.PokeInfoByGame[iPos].type)
							{
								//Decimal
								case 0:
								//BCD
								case 2:
								//Numeric
								case 3:
								//Numeric ascii
								case 4:
								//Long
								case 5:
									{
										int n = 0;
										int val2 = atoi(Val);
										while (val2 > 0)
										{
											Val[n] = val2 & 0x0ff;
											val2 = val2 >> 8;
											n += 1;
										}
										Val[n] = '\0';
										ReverseByte(Val);
										CheckNumByte(Val,n);
										ApplyPoke(Val,add);
									}
								break;
								//Hexadecimal
								case 1:
									{
										int n = 0;
										int val2 = strtoul(Val, NULL, 16);
										while (val2 > 0)
										{
											Val[n] = val2 & 0x0ff;
											val2 = val2 >> 8;
											n += 1;
										}
										Val[n] = '\0';
										ReverseByte(Val);
										CheckNumByte(Val,n);
										ApplyPoke(Val,add);
									}
								break;
								//string
								case 6:
								{
									ApplyPoke(Val,add);
								}
								break;

								default:
								break;
							}

						}

					}

				}
				break;
			}
		}
		break;

		case WM_CLOSE:
			DestroyWindow(hDialog);
			break;


		case WM_DESTROY:
		{
			HWND hListView;

			hListView = GetDlgItem(hDialog,IDC_LIST_CHEATS);

			if (hListView!=0)
			{
				ListView_DeleteAllItems(hListView);
				hListView = 0;
			}
		}
		break;

	}

	return FALSE;
}

void	CheatDatabaseDialog(HWND hParent)
{
	HWND hDialog;

	HINSTANCE hInstance = (HINSTANCE)GetWindowLong(hParent, GWL_HINSTANCE);

	hDialog = CreateDialog (hInstance, MAKEINTRESOURCE(IDD_DIALOG_CHEAT_DATABASE), 0, CheatDatabase_Dialog_Proc);

	ShowWindow(hDialog,TRUE);
}

